unit SMB;

interface

uses
  windows, sysutils, MyUtils, Forms;

var
  Data: dword;

function DlPortReadPortUchar(Port: cardinal): cardinal;
stdcall; external'dlportio.dll';
function DlPortReadPortUshort(Port: cardinal): cardinal;
stdcall; external'dlportio.dll';
function DlPortReadPortUlong(Port: cardinal): cardinal;
stdcall; external'dlportio.dll';
procedure DlPortWritePortUchar(Port: cardinal; Value: cardinal);
stdcall; external'dlportio.dll';
procedure DlPortWritePortUshort(Port: cardinal; Value: cardinal);
stdcall; external'dlportio.dll';
procedure DlPortWritePortUlong(Port: cardinal; Value: cardinal);
stdcall; external'dlportio.dll';

//function smbGetAddress(BaseAddr: word): string;
function smbGetReg(BaseAddr: word; Reg: byte; Chip_Addr: byte): word;
function smbGetRegWord(BaseAddr: word; Reg: byte; Chip_Addr: byte): word;
procedure smbSetReg(BaseAddr: word; Reg: byte; Chip_Addr: byte; Data: byte);
procedure smbWaitForFree(BaseAddr: word);
procedure smbWaitForEnd(BaseAddr: word);

const
  RW_WRITE = 0;
  RW_READ = 1;
  RW_BYTE = $20;
  RW_WORD = $30;
  SMB_TIMEOUT = 2;

implementation

procedure smbSetReg(BaseAddr: word; Reg: byte; Chip_Addr: byte; Data: byte);
begin
  smbWaitForFree(BaseAddr);
  DlPortWritePortUshort(BaseAddr + 3, (Chip_Addr shl 1) or RW_WRITE);
  DlPortWritePortUshort(BaseAddr + 1, RW_BYTE);
  DlPortWritePortUshort(BaseAddr + 4, Data);
  DlPortWritePortUshort(BaseAddr + 7, Reg);
  DlPortWritePortUshort(BaseAddr + 2, $0);
  smbWaitForEnd(BaseAddr);
end;

function smbGetReg(BaseAddr: word; Reg: byte; Chip_Addr: byte): word;
var
  Data: cardinal;
begin
  smbWaitForFree(BaseAddr);
  DlPortWritePortUchar(BaseAddr + 3, (Chip_Addr shl 1) or RW_READ);
  DlPortWritePortUchar(BaseAddr + 1, RW_BYTE);
  DlPortWritePortUchar(BaseAddr + 4, $0);
  DlPortWritePortUchar(BaseAddr + 7, Reg);
  DlPortWritePortUchar(BaseAddr + 2, $0);
  smbWaitForEnd(BaseAddr);
  Data:=DlPortReadPortUchar(BaseAddr + 4);
  Result := Data;
end;

function smbGetRegWord(BaseAddr: word; Reg: byte; Chip_Addr: byte): word;
var
  Data: cardinal;
begin
  smbWaitForFree(BaseAddr);
  DlPortWritePortUchar(BaseAddr + 3, (Chip_Addr shl 1) or RW_READ);
  DlPortWritePortUchar(BaseAddr + 1, RW_WORD);
  DlPortWritePortUchar(BaseAddr + 4, $0);
  DlPortWritePortUchar(BaseAddr + 5, $0);
  DlPortWritePortUchar(BaseAddr + 7, Reg);
  DlPortWritePortUchar(BaseAddr + 2, $0);
  smbWaitForEnd(BaseAddr);
  Data:=DlPortReadPortUchar(BaseAddr + 4)+256*DlPortReadPortUchar(BaseAddr + 5);
  Result := Data;
end;

{
function smbGetAddress(BaseAddr: word): string;
var
  Data: word;
  Cheque: string;
  idx: integer;
begin
  Cheque := '';
  for idx := $20 to $4F do begin
    smbWaitForFree(BaseAddr);
    DlPortWritePortUchar(BaseAddr + 5, 0);
    DlPortWritePortUchar(BaseAddr + 6, 0);
    Data := smbGetReg(BaseAddr, $00, idx);
    if (Data and $FF) <> 0 then begin
      Cheque := Cheque + rStr('00' + Format('%x', [idx]), 2);
    end;
  end;
  Result := Cheque;
end;
}
procedure smbWaitForFree(BaseAddr: word);
var
  Status: byte;
  cnt:integer;
begin
  DlPortWritePortUchar(BaseAddr,$FF);
  Status := DlPortReadPortUchar(BaseAddr);
  cnt:=SMB_TIMEOUT;
  while ((Status and $4) = 0) and (cnt>0) do begin
    Application.ProcessMessages;
    Sleep(1);
    Status := DlPortReadPortUchar(BaseAddr);
    dec(cnt);
  end;
end;

procedure smbWaitForEnd(BaseAddr: word);
var
  Status: byte;
  cnt:integer;
begin
  Status := DlPortReadPortUchar(BaseAddr);
  cnt:=SMB_TIMEOUT;
  while ((Status and $30) = 0) and (cnt>0) do begin
    Application.ProcessMessages;
    Sleep(1);
    Status := DlPortReadPortUchar(BaseAddr);
    dec(cnt);
  end;
end;

end.
