unit Monitor;

interface

uses
  GL520SM, windows, SMB, Menus, ToolWin, Graphics, ImgList, Controls,
  StdCtrls, CheckLst, Forms, MyUtils, Classes, PCI,
  SysUtils, ComCtrls, ExtCtrls, TrayIcon;


const
  SystemBasicInformation = 0;
  SystemPerformanceInformation = 2;
  SystemTimeInformation = 3;
  timerng=60;

type
 TPDWord = ^DWORD;

  TSystem_Basic_Information = packed record
    dwUnknown1: DWORD;
    uKeMaximumIncrement: ULONG;
    uPageSize: ULONG;
    uMmNumberOfPhysicalPages: ULONG;
    uMmLowestPhysicalPage: ULONG;
    uMmHighestPhysicalPage: ULONG;
    uAllocationGranularity: ULONG;
    pLowestUserAddress: Pointer;
    pMmHighestUserAddress: Pointer;
    uKeActiveProcessors: ULONG;
    bKeNumberProcessors: byte;
    bUnknown2: byte;
    wUnknown3: word;
    end;

  TSystem_Performance_Information = packed record
    liIdleTime: LARGE_INTEGER; {LARGE_INTEGER}
    dwSpare: array[0..75] of DWORD;
    end;

  TSystem_Time_Information = packed record
    liKeBootTime: LARGE_INTEGER;
    liKeSystemTime: LARGE_INTEGER;
    liExpTimeZoneBias: LARGE_INTEGER;
    uCurrentTimeZoneId: ULONG;
    dwReserved: DWORD;
    end;

  TMainForm = class(TForm)
    Timer: TTimer;
    Page: TPageControl;
    TabMain: TTabSheet;
    GPCI: TGroupBox;
    Label1: TLabel;
    lblVID: TLabel;
    lblVIN: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblDID: TLabel;
    lblDIN: TLabel;
    Label4: TLabel;
    Label8: TLabel;
    lblRev: TLabel;
    lblBus: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lblDev: TLabel;
    lblFun: TLabel;
    Label9: TLabel;
    Label7: TLabel;
    lblSMBA: TLabel;
    GroupBox1: TGroupBox;
    Label12: TLabel;
    lblCVIN: TLabel;
    lblCDIN: TLabel;
    Label14: TLabel;
    Label10: TLabel;
    lblCVID: TLabel;
    lclCDID: TLabel;
    Label13: TLabel;
    GroupBox6: TGroupBox;
    TabDebug: TTabSheet;
    DebugPrint: TMemo;
    Label11: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    LCPUT: TLabel;
    LMBT: TLabel;
    LCPUF: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label17: TLabel;
    LCPU: TLabel;
    Label22: TLabel;
    TBCPU: TTrackBar;
    TI: TTrayIcon;
    TabSetup: TTabSheet;
    Label18: TLabel;
    Label19: TLabel;
    EFOff: TEdit;
    EFOn: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    E0: TEdit;
    E100: TEdit;
    EClk2: TEdit;
    Label20: TLabel;
    EClk4: TEdit;
    Label21: TLabel;
    EClk8: TEdit;
    Label28: TLabel;
    EClk1: TEdit;
    Label29: TLabel;
    PB: TImage;
    Timer1: TTimer;
    SB: TStatusBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    Procedure Display_PCI_Info;
    Procedure Display_SMBUS_Info;
    procedure Button1Click(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure TBCPUChange(Sender: TObject);
    procedure TIClick(Sender: TObject);
    procedure E100Change(Sender: TObject);
    procedure E0Change(Sender: TObject);
    procedure EFOffChange(Sender: TObject);
    procedure EFOnChange(Sender: TObject);
    procedure EClk1Change(Sender: TObject);
    procedure EClk2Change(Sender: TObject);
    procedure EClk4Change(Sender: TObject);
    procedure EClk8Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
  { Private declarations }

  public
  { Public declarations }
  end;

var
  MainForm: TMainForm;
  PCI_Structure1: PCI_Info;
  CHIP_Structure: Chip_Info;
  Valori: Packet_Data;
  SMB_AF: string;
  SMB_CF: integer;
  MutexSMB: integer;
  MutexISA: integer;


  CPUTemp,lastCPUTemp:integer;
  MBTemp,lastMBTemp:integer;
  CPUFan,lastCPUFan:integer;
  CPU,lastCPU,xCPU:integer;
  dCPUTemp,dMBTemp,dCPUFan,dCPU:array [0..(timerng-1)] of integer;
  dTime:integer=timerng;
  xtime:integer=0;
  cool:integer=0;

  t100,t0,fon,foff,clk1,clk2,clk4,clk8:integer;

  NtQuerySystemInformation: function(infoClass: DWORD;
    buffer: Pointer;
    bufSize: DWORD;
    returnSize: TPDword): DWORD; stdcall = nil;


  liOldIdleTime: LARGE_INTEGER = ();
  liOldSystemTime: LARGE_INTEGER = ();


implementation

{$R *.DFM}


function Li2Double(x: LARGE_INTEGER): Double;
begin
  Result := x.HighPart * 4.294967296E9 + x.LowPart
end;

function GetCPUUsage:integer;
var
  SysPerfInfo: TSystem_Performance_Information;
  SysTimeInfo: TSystem_Time_Information;
  status: Longint; {long}
  dbSystemTime: Double;
  dbIdleTime: Double;
begin
  if @NtQuerySystemInformation = nil then
    NtQuerySystemInformation := GetProcAddress(GetModuleHandle('ntdll.dll'),
      'NtQuerySystemInformation');

  result:=100;
 {
  // get new system time
  status := NtQuerySystemInformation(SystemTimeInformation, @SysTimeInfo, SizeOf(SysTimeInfo), nil);
  if status <> 0 then Exit;

  // get new CPU's idle time
  status := NtQuerySystemInformation(SystemPerformanceInformation, @SysPerfInfo, SizeOf(SysPerfInfo), nil);
  if status <> 0 then Exit;

  // store new CPU's idle and system time
  liOldIdleTime := SysPerfInfo.liIdleTime;
  liOldSystemTime := SysTimeInfo.liKeSystemTime;

  // wait one second
  Sleep(100);
}
  // get new system time
  status := NtQuerySystemInformation(SystemTimeInformation, @SysTimeInfo, SizeOf(SysTimeInfo), nil);
  if status <> 0 then Exit;

  // get new CPU's idle time
  status := NtQuerySystemInformation(SystemPerformanceInformation, @SysPerfInfo, SizeOf(SysPerfInfo), nil);
  if status <> 0 then Exit;

  // CurrentValue = NewValue - OldValue
  dbIdleTime := Li2Double(SysPerfInfo.liIdleTime) - Li2Double(liOldIdleTime);
  dbSystemTime := Li2Double(SysTimeInfo.liKeSystemTime) - Li2Double(liOldSystemTime);

  // CurrentCpuIdle = IdleTime / SystemTime
  dbIdleTime := dbIdleTime / dbSystemTime;

  // CurrentCpuUsage% = 100 - (CurrentCpuIdle * 100) / NumberOfProcessors
  dbIdleTime := 100.0 - 100*dbIdleTime;

  // store new CPU's idle and system time
  liOldIdleTime := SysPerfInfo.liIdleTime;
  liOldSystemTime := SysTimeInfo.liKeSystemTime;

  result:=round(int(dbIdleTime));

end;

function rot(data:cardinal):cardinal;
begin
  result:=((((((((data and $FF) shl 8)+(data and $FF00)) shl 8)+(data and $0000FF)) shl 8)+(data and $000000FF)) shl 8)
end;

function Get_Hex(Data: cardinal; nbyte: smallint): string;
begin
  Result := rStr('00000000' + Format('%x', [Data]), nbyte);
end;


procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var acpiport:integer;
begin
  acpiport:=(Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$10)) and $FFFE;
  Set_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C,Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C) or $00808000);
  DlPortWritePortUchar(acpiport+$11,$00);
  DlPortWritePortUchar(acpiport+$10,$08);
  CloseHandle(MutexSMB);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.HintColor:=$009DCEFF;
  Application.HintPause:=300;
  Application.HintHidePause:=5000;
  lastCPUTemp:=0;
  lastCPUFan:=0;
  lastMBTemp:=0;
  lastCPU:=0;
  t100:=StrToInt(E100.Text);
  t0:=StrToInt(E0.Text);
  foff:=StrToInt(EFOff.Text);
  fon:=StrToInt(EFOn.Text);
  clk1:=StrToInt(EClk1.Text);
  clk2:=StrToInt(EClk2.Text);
  clk4:=StrToInt(EClk4.Text);
  clk8:=StrToInt(EClk8.Text);
  DebugPrint.Lines.add('Load form ...');
  MutexISA := CreateMutex(nil, false, 'Access_ISABUS.HTP.Method');
  MutexSMB := CreateMutex(nil, false, 'Access_SMBUS.HTP.Method');
  DebugPrint.Lines.add('Scan PCI ...');
  PCI_Structure1 := Scan_PCI;
  if PCI_Structure1.SMB_Address <> 0 then begin
     DebugPrint.Lines.add('Scan PCI ended ...');
     Display_PCI_Info;

       DebugPrint.Lines.add('Read SMBUS ...');
       CHIP_Structure := GL520SM_Info(PCI_Structure1.SMB_Address, $2D);
       Display_SMBUS_Info;

     Timer1.Enabled:=true;
     end
  else begin
    DebugPrint.Lines.add('PCI chip not found or unknow !!!');
    DebugPrint.Lines.add('STOP program !!!');
  end;
end;

Procedure TMainForm.Display_SMBUS_Info;
begin
    WaitforSingleObject(MutexSMB, INFINITE);
    lblCVID.Caption := '0x' + Format('%x', [CHIP_Structure.Vendor_ID]);
    lblCVIN.Caption := CHIP_Structure.Vendor_Name;
    lclCDID.Caption := '0x' + Format('%x', [CHIP_Structure.Device_ID]);
    lblCDIN.Caption := CHIP_Structure.Device_Name;
    ReleaseMutex(MutexSMB);
    Timer.Enabled:=True;
    DebugPrint.Lines.add('Start program ... ');
    Page.ActivePage:=TabMain;
end;

Procedure TMainForm.Display_PCI_Info;
begin
    lblVID.Caption := '0x' + Get_Hex(PCI_Structure1.Vendor_ID, 4);
    lblDID.Caption := '0x' + Get_Hex(PCI_Structure1.Device_ID, 4);
    lblRev.Caption := '0x' + Get_Hex(PCI_Structure1.Rev, 2);
    lblBus.Caption := '0x' + Get_Hex(PCI_Structure1.Bus, 2);
    lblDev.Caption := '0x' + Get_Hex(PCI_Structure1.Dev, 2);
    lblFun.Caption := '0x' + Get_Hex(PCI_Structure1.Fun, 2);
    lblSMBA.Caption := '0x' + Get_Hex(PCI_Structure1.SMB_Address, 4);
    lblVIN.Caption := PCI_Structure1.Vendor_Name;
    lblDIN.Caption := PCI_Structure1.Device_Name;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var i:byte;
    data:word;
begin
  DebugPrint.Lines.Add('Scan SMBus ...');
  for i:=0 to 127 do begin
    data:=smbGetReg(PCI_Structure1.SMB_Address,$00,i);
    if data<>0 then DebugPrint.Lines.Add('SMBus 0x'+IntToHex(PCI_Structure1.SMB_Address,4)+': Chip 0x'+IntToHex(i,2)+' Dev '+IntToHex(data,2))
  end;
  DebugPrint.Lines.Add('Scan SMBus ended ...');
end;

procedure TMainForm.TimerTimer(Sender: TObject);
var i:integer;
    upd,uph,upm,ups:integer;
    upt:longword;
    uptime,log:string;
    f:textfile;
begin
  SetPriorityClass(GetCurrentProcess,HIGH_PRIORITY_CLASS);

  upt:=GetTickCount div 1000;
  uptime:='';
  ups:=upt;
  upm:=ups div 60;
  uph:=upm div 60;
  upd:=uph div 24;
  uph:=uph mod 24;
  upm:=upm mod 60;
  ups:=ups mod 60;
  if upt>=86400 then begin
    uptime:=uptime+inttostr(upd)+'d ';
  end;
  if upt>=3600 then begin
    if ((uph<10) and (upd>0)) then uptime:=uptime+'0';
    uptime:=uptime+inttostr(uph)+'h ';
  end;
  if upt>=60 then begin
    if ((upm<10) and (uph>0)) then uptime:=uptime+'0';
    uptime:=uptime+inttostr(upm)+'m ';
  end;
    if ((ups<10) and (upm>0)) then uptime:=uptime+'0';
    uptime:=uptime+inttostr(ups)+'s';

  if SB.Panels[0].Text='' then begin
    AssignFile(f,'C:\Windows\System32\LogFiles\CPUTemp.log');
    try
      Append(f);
    except
      Rewrite(f);
    end;
    Writeln(f,'@Boottime: '+uptime);
    Flush(f);
    CloseFile(f);
  end;
  SB.Panels[0].Text:=' Uptime: '+uptime;

  CPUTemp:=((smbGetReg(PCI_Structure1.SMB_Address,$0E,$2D)-(130+t0))*100) div (t100-t0);
  LCPUT.Caption:=IntToStr(CPUTemp);
  MBTemp:=((smbGetReg(PCI_Structure1.SMB_Address,$04,$2D)-(130+t0))*100) div (t100-t0);
  LMBT.Caption:=IntToStr(MBTemp);
  CPUFan:=smbGetRegWord(PCI_Structure1.SMB_Address,$07,$2D) and $FF;
  if CPUFan<>0 then CPUFan:=960000 div (CPUFan*4);
  LCPUF.Caption:=IntToStr(CPUFan);
  if (CPUTemp<foff) and (CPUTemp>15) then
    Set_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C,(Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C) and $FF7FFFFF) or $00008000);
  if (CPUTemp>fon) and (CPUTemp<75) then
    Set_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C,Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C) or $00808000);
  if (cool<3) and (CPUTemp>=clk8) then begin
    TBCPU.Position:=7;
    cool:=3;
  end;
  if (cool<2) and (CPUTemp>=clk4) then begin
    TBCPU.Position:=6;
    cool:=2;
  end;
  if (cool<1) and (CPUTemp>=clk2) then begin
    TBCPU.Position:=4;
    cool:=1;
  end;
  if (cool>0) and (CPUTemp<=clk1) then begin
    TBCPU.Position:=0;
    cool:=0;
  end;
  if (cool>1) and (CPUTemp<=clk2) then begin
    TBCPU.Position:=4;
    cool:=1;
  end;
  if (cool>2) and (CPUTemp<=clk4) then begin
    TBCPU.Position:=6;
    cool:=2;
  end;
  CPU:=(GetCPUUsage*(8-TBCPU.Position)) div 8;
  LCPU.Caption:=IntToStr(CPU);

  if dTime=timerng then begin
    for i:=0 to timerng-1 do begin
      dCPUTemp[i]:=CPUTemp;
      dMBTemp[i]:=MBTemp;
      dCPUFan[i]:=CPUFan;
      dCPU[i]:=CPU;
    end;
    dTime:=0;
  end;

  dCPUTemp[dTime]:=CPUTemp;
  dMBTemp[dTime]:=MBTemp;
  dCPUFan[dTime]:=CPUFan;
  dCPU[dTime]:=CPU;

  if dTime=0 then begin

    CPUTemp:=0;
    MBTemp:=0;
    CPUFan:=0;
    CPU:=0;
    for i:=0 to timerng-1 do begin
      CPUTemp:=CPUTemp+dCPUTemp[i];
      MBTemp:=MBTemp+dMBTemp[i];
      CPUFan:=CPUFan+dCPUFan[i];
      CPU:=CPU+dCPU[i];
    end;
    CPUTemp:=CPUTemp div timerng;
    MBTemp:=MBTemp div timerng;
    CPUFan:=CPUFan div timerng;
    CPU:=CPU div timerng;
    PB.Canvas.Lock;
    PB.Canvas.Draw(-1,0,PB.Picture.Graphic);
    PB.Canvas.Pen.Color:=clWhite;
    PB.Canvas.MoveTo(374,0);
    PB.Canvas.LineTo(374,100);
    if xtime=0 then begin
      PB.Canvas.Pen.Color:=clSilver;
      PB.Canvas.MoveTo(374,0);
      PB.Canvas.LineTo(374,100);
    end else begin
      for i:=10 downto 0 do PB.Canvas.Pixels[374,10*i]:=clSilver;
    end;
    PB.Canvas.Pen.Color:=clGreen;
    PB.Canvas.MoveTo(373,100-lastCPU);
    PB.Canvas.LineTo(374,100-CPU);
    PB.Canvas.Pen.Color:=clRed;
    PB.Canvas.MoveTo(373,100-lastCPUTemp);
    PB.Canvas.LineTo(374,100-CPUTemp);
    PB.Canvas.Pen.Color:=clBlue;
    PB.Canvas.MoveTo(373,100-lastMBTemp);
    PB.Canvas.LineTo(374,100-MBTemp);
    PB.Canvas.Pen.Color:=clFuchsia;
    PB.Canvas.MoveTo(373,100-(lastCPUFan div 100));
    PB.Canvas.LineTo(374,100-(CPUFan div 100));
    PB.Canvas.Unlock;

    lastCPUTemp:=CPUTemp;
    lastMBTemp:=MBTemp;
    lastCPUFan:=CPUFan;
    lastCPU:=CPU;

    CPUTemp:=0;
    MBTemp:=0;
    for i:=0 to timerng-1 do begin
      CPUTemp:=CPUTemp+dCPUTemp[i];
      MBTemp:=MBTemp+dMBTemp[i];
    end;
    CPUTemp:=(100*CPUTemp) div timerng;
    MBTemp:=(100*MBTemp) div timerng;
    AssignFile(f,'C:\Windows\System32\LogFiles\CPUTemp.log');
    try
      Append(f);
    except
      Rewrite(f);
    end;
    log:=DateToStr(date)+' '+TimeToStr(time)+'; CPUTemp: '+IntToStr(CPUTemp div 100)+'.'+IntToStr((CPUTemp mod 100) div 10)+IntToStr((CPUTemp mod 100) mod 10)+' C; RoomTemp: '+IntToStr(MBTemp div 100)+'.'+IntToStr((MBTemp mod 100) div 10)+IntToStr((MBTemp mod 100) mod 10)+' C; CPU: '+IntToStr(CPU)+' %; CPUFan: '+IntToStr(CPUFan)+' RPM';
    TI.ToolTip:='CPUTemp: '+IntToStr(CPUTemp div 100)+'.'+IntToStr((CPUTemp mod 100) div 10)+IntToStr((CPUTemp mod 100) mod 10)+' C; RoomTemp: '+IntToStr(MBTemp div 100)+'.'+IntToStr((MBTemp mod 100) div 10)+IntToStr((MBTemp mod 100) mod 10)+' C; CPU: '+IntToStr(CPU)+' %; CPUFan: '+IntToStr(CPUFan)+' RPM';
    Writeln(f,log);
    Flush(f);
    CloseFile(f);

    xtime:=(xtime+1) mod 15;
  end;
  dTime:=(dTime+1) mod timerng;
end;

procedure TMainForm.TBCPUChange(Sender: TObject);
var acpiport:integer;
begin
  acpiport:=(Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$10)) and $FFFE;
  if TBCPU.Position>0 then
    DlPortWritePortUchar(acpiport+$10,32-2*TBCPU.Position);
//  if TBCPU.Position=7 then
//    Set_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C,Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C) and $FF7FFFFF);
  if TBCPU.Position=0 then begin
    DlPortWritePortUchar(acpiport+$10,$00);
    DlPortWritePortUchar(acpiport+$11,$00);
    TI.ToolTip:='Eyes';
  end else begin
    DlPortWritePortUchar(acpiport+$11,$02);
    TI.ToolTip:='Eyes - CPU Power '+IntToStr(round(100-12.5*TBCPU.Position))+'%';
  end;
end;

procedure TMainForm.TIClick(Sender: TObject);
begin
  if MainForm.Visible then MainForm.Visible:=false else MainForm.Visible:=true;
end;

procedure TMainForm.E100Change(Sender: TObject);
begin
  if StrToInt(E100.Text)<=StrToInt(E0.Text) then E0.Text:=IntToStr(StrToInt(E100.Text)-1);
  t100:=StrToInt(E100.Text);
end;

procedure TMainForm.E0Change(Sender: TObject);
begin
  if StrToInt(E0.Text)>=StrToInt(E100.Text) then E100.Text:=IntToStr(StrToInt(E0.Text)+1);
  t0:=StrToInt(E0.Text);
end;

procedure TMainForm.EFOffChange(Sender: TObject);
begin
  foff:=StrToInt(EFOff.Text);
end;

procedure TMainForm.EFOnChange(Sender: TObject);
begin
  fon:=StrToInt(EFOn.Text);
end;

procedure TMainForm.EClk1Change(Sender: TObject);
begin
  clk1:=StrToInt(EClk1.Text);
end;

procedure TMainForm.EClk2Change(Sender: TObject);
begin
  clk2:=StrToInt(EClk2.Text);
end;

procedure TMainForm.EClk4Change(Sender: TObject);
begin
  clk4:=StrToInt(EClk4.Text);
end;

procedure TMainForm.EClk8Change(Sender: TObject);
begin
  clk8:=StrToInt(EClk8.Text);
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  if (CPUTemp<fon) and (CPUTemp>15) then
    Set_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C,(Get_PCI_Reg(PCI_Structure1.Bus,PCI_Structure1.Dev,PCI_Structure1.Fun,$7C) and $FF7FFFFF) or $00008000);
  Timer1.Enabled:=false;
  MainForm.Visible:=false;
end;

end.
