{ Procedura per la scansione delle porte PCI
|
| Info from: Alfredo Milani-Comparetti
|
| Si ricerca un valore (via Get_PCI_Reg) diverso da 0xFFFFFFFF o 0x0, in caso di
| matching si analizza il database interno per il riconoscimento del CHIP
| via Get_INFO.
}
unit PCI;

interface

uses
  windows, sysutils, MyUtils;

type
  PCI_Info = record
    Vendor_ID: word;
    Vendor_Name: string;
    Device_ID: word;
    Device_Name: string;
    Rev: byte;
    Bus: byte;
    Dev: byte;
    Fun: byte;
    SMB_Address: word;
  end;

var
  PCI_Structure: PCI_Info;

function DlPortReadPortUchar(Port: cardinal): cardinal; stdcall; external'dlportio.dll';
function DlPortReadPortUshort(Port: cardinal): cardinal; stdcall; external'dlportio.dll';
function DlPortReadPortUlong(Port: cardinal): cardinal; stdcall; external'dlportio.dll';
procedure DlPortReadPortBufferUchar(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';
procedure DlPortReadPortBufferUshort(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';
procedure DlPortReadPortBufferUlong(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortUchar(Port: cardinal; Value: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortUshort(Port: cardinal; Value: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortUlong(Port: cardinal; Value: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortBufferUchar(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortBufferUshort(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';
procedure DlPortWritePortBufferUlong(Port: cardinal; Buffer: variant; Count: cardinal); stdcall; external'dlportio.dll';

function Get_PCI_Reg(Bus: cardinal; Dev: cardinal; Fun: cardinal; Reg: cardinal): cardinal;
procedure Set_PCI_Reg(Bus: cardinal; Dev: cardinal; Fun: cardinal; Reg: cardinal; Value:cardinal);
function Scan_PCI: PCI_Info;
function Get_Info(Data: dword; Bus: cardinal; Dev: cardinal; Fun: cardinal): PCI_Info;

implementation

procedure Set_PCI_Reg(Bus: cardinal; Dev: cardinal; Fun: cardinal; Reg: cardinal; Value:cardinal);
var cc: cardinal;
  t: cardinal;
begin
  cc := $80000000;
  cc := cc or ((Bus and $FF) shl 16);//Bus
  cc := cc or ((Dev and $1F) shl 11);//Dev
  cc := cc or ((Fun and $07) shl 8);//func
  cc := cc or ((Reg and $FC));//Reg
  t := DlPortReadPortUlong($CF8);
  DlPortWritePortUlong($CF8, cc);
  DlPortWritePortUlong($CFC, Value);
  DlPortWritePortUlong($CF8, t);
end;

function Get_PCI_Reg(Bus: cardinal; Dev: cardinal; Fun: cardinal; Reg: cardinal): cardinal;
var cc: cardinal;
  t: cardinal;
begin
  cc := $80000000;
  cc := cc or ((Bus and $FF) shl 16);//Bus
  cc := cc or ((Dev and $1F) shl 11);//Dev
  cc := cc or ((Fun and $07) shl 8);//func
  cc := cc or ((Reg and $FC));//Reg
  t := DlPortReadPortUlong($CF8);
  DlPortWritePortUlong($CF8, cc);
  Result := DlPortReadPortUlong($CFC);
  DlPortWritePortUlong($CF8, t);
end;

function Scan_PCI: PCI_Info;
  label Exit1;
var
  Bus, Dev, Fun: integer;
  Info: PCI_Info;
  Data: dword;
begin
  Get_Info(Get_PCI_Reg(0,7,0,0),0,7,0);
  for Bus := 0 to $FF do begin
    for Dev := 0 to $1F do begin
      for Fun := 0 to $07 do begin
        Data := Get_PCI_Reg(Bus, Dev, Fun, 0);
        Info.SMB_Address := 0;
        if (Data <> $FFFFFFFF) and (Data <> 0) then begin
          Info := Get_Info(Data, Bus, Dev, Fun);
          if Info.SMB_Address <> 0 then goto Exit1;
        end;
      end;
    end;
  end;
  Exit1:
  Result := Info;
end;

function Get_Info(Data: dword; Bus: cardinal; Dev: cardinal; Fun: cardinal): PCI_Info;
begin
  PCI_Structure.Vendor_ID := Data and $FFFF;
  PCI_Structure.Device_ID := (Data shr 16) and $FFFF;
  PCI_Structure.Bus := Bus;
  PCI_Structure.Dev := Dev;
  PCI_Structure.Fun := Fun;
  case Data of
    $71138086:
      begin
        PCI_Structure.SMB_Address := Get_PCI_Reg(Bus, Dev, Fun, $90) and $FFF0;
        PCI_Structure.Rev := Get_PCI_Reg(Bus, Dev, Fun, 8) and $FF;
        PCI_Structure.Vendor_Name := 'Intel';
        PCI_Structure.Device_Name := '82371AB/EB (PIIX4)';
      end;
    $24138086:
      begin
        PCI_Structure.SMB_Address := Get_PCI_Reg(Bus, Dev, Fun, $20) and $FFF0;
        PCI_Structure.Rev := Get_PCI_Reg(Bus, Dev, Fun, 8) and $FF;
        PCI_Structure.Vendor_Name := 'Intel';
        PCI_Structure.Device_Name := '82801AA/ICH';
      end;
    $24238086:
      begin
        PCI_Structure.SMB_Address := Get_PCI_Reg(Bus, Dev, Fun, $20) and $FFF0;
        PCI_Structure.Rev := Get_PCI_Reg(Bus, Dev, Fun, 8) and $FF;
        PCI_Structure.Vendor_Name := 'Intel';
        PCI_Structure.Device_Name := '82801AB/ICH0';
      end;
    $24438086:
      begin
        PCI_Structure.SMB_Address := Get_PCI_Reg(Bus, Dev, Fun, $20) and $FFF0;
        PCI_Structure.Rev := Get_PCI_Reg(Bus, Dev, Fun, 8) and $FF;
        PCI_Structure.Vendor_Name := 'Intel';
        PCI_Structure.Device_Name := '82801BA/ICH2';
      end;
    $710110B9:
      begin
        PCI_Structure.SMB_Address := Get_PCI_Reg(Bus, Dev, Fun, $14) and $FFE0;
        PCI_Structure.Rev := Get_PCI_Reg(Bus, Dev, Fun, 8) and $FF;
        PCI_Structure.Vendor_Name := 'ALi';
        PCI_Structure.Device_Name := 'M7101';
      end;
    $153310B9:
      begin
        Set_PCI_Reg(Bus,Dev,Fun,$5C,Get_PCI_Reg(Bus,Dev,Fun,$5C) and $FBFFFFFF);
      end;
  end;
  Result := PCI_Structure;
end;

end.

